{*                                                                       *}
{*                                                                       *}
{*                      RESTRICTED RIGHTS LEGEND                         *}
{*                                                                       *}
{* Use, duplication, or disclosure by the Government is subject to       *}
{* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  *}
{* Technical Data and Computer Software clause at 252.227-7013.          *}
{*                                                                       *}
{*                    TEXAS INSTRUMENTS INCORPORATED.                    *}
{*                            P.O. BOX 149149                            *}
{*                         AUSTIN, TEXAS 78714-9149                      *}
{*                              MS 2151                                  *}
{*                                                                       *}
{*  Copyright (C) 1987,1988,1989,1990 Texas Instruments Incorporated.    *}
{*  All rights reserved.                                                 *}
{*                                                                       *}

UNIT CommIntf;

INTERFACE

USES memtypes;

CONST
 	to_acb = 0;		{Flags to use when copying parms with copy_parms_*}
	to_array = 1;

	PROCEDURE initialize_comm;
	PROCEDURE handle_command;

	FUNCTION PTR32TO24(cmd:Ptr): ptr;  
	FUNCTION PTR24TO32(cmd:Ptr): ptr;

	FUNCTION NUBUS_READ(slot: integer; offset:  longint):  longint;
	PROCEDURE NUBUS_WRITE(slot: integer; offset, value:  longint);
	FUNCTION NUBUS_READ_BYTE(slot: integer; offset:  longint):  integer;
	PROCEDURE NUBUS_WRITE_BYTE(slot: integer; offset: longint; value: integer); 
	
	PROCEDURE BLOCK_SWAP_16B(aPtr, bPtr : Ptr; length : longint);
	PROCEDURE BLOCK_SWAP_32B(aPtr, bPtr : Ptr; length : longint);

	PROCEDURE send_command(cmd:Ptr; ch:integer);
	PROCEDURE send_command_and_wait(cmd:Ptr; channel:integer);
	
	FUNCTION  get_command(channel, no_hang_p:integer):Ptr;
	FUNCTION  get_acb(size:integer):Ptr;

	FUNCTION opcode(cmd:Ptr): integer;
	PROCEDURE set_opcode(cmd:Ptr; value:integer);
	
	FUNCTION subopcode(cmd:Ptr): integer;
	PROCEDURE set_subopcode(cmd:Ptr; value:integer);

	FUNCTION servicer_complete(cmd:Ptr): Boolean;
	PROCEDURE set_servicer_complete(cmd:Ptr; value:Boolean);

	FUNCTION requestor_complete(cmd:Ptr): Boolean;
	PROCEDURE set_requestor_complete(cmd:Ptr; value:Boolean);

	FUNCTION input_complete(cmd:Ptr): Boolean;
	PROCEDURE set_input_complete(cmd:Ptr; value:Boolean);

	FUNCTION error_code(cmd:Ptr): integer;
	PROCEDURE set_error_code(cmd:Ptr; value:integer);

	FUNCTION parm_bytes(cmd:Ptr): longint;
	PROCEDURE set_parm_bytes(cmd:Ptr; value:longint);

	FUNCTION data_bytes(cmd:Ptr): longint;
	PROCEDURE set_data_bytes(cmd:Ptr; value:longint);

	FUNCTION parm_8b(cmd:Ptr; parm_number:longint): integer;
	PROCEDURE set_parm_8b(cmd:Ptr; parm_number:longint; value:integer);
	FUNCTION parm_8b_addr(cmd:Ptr; parm_number:integer): ptr;
	PROCEDURE copy_parms_8b(cmd,arr:Ptr;
								 parm_number, number_of_parms_to_copy, direction:longint);

	FUNCTION parm_16b(cmd:Ptr; parm_number:longint): integer;
	PROCEDURE set_parm_16b(cmd:Ptr; parm_number:longint; value:integer);
	FUNCTION parm_16b_addr(cmd:Ptr; parm_number:longint): ptr;
	PROCEDURE copy_parms_16b(cmd,arr:Ptr;
								 parm_number, number_of_parms_to_copy, direction:longint);

	FUNCTION parm_32b(cmd:Ptr; parm_number:longint): longint;  {**ab**}
	PROCEDURE set_parm_32b(cmd:Ptr; parm_number:longint; value:longint);  {**ab**}
	FUNCTION parm_32b_addr(cmd:Ptr; parm_number:longint): ptr;
	PROCEDURE copy_parms_32b(cmd, arr:Ptr;
								 parm_number, number_of_parms_to_copy, direction:longint);

IMPLEMENTATION

	PROCEDURE initialize_comm;  EXTERNAL;
	PROCEDURE handle_command;  EXTERNAL;

	FUNCTION PTR32TO24(cmd:Ptr): ptr; EXTERNAL; 
	FUNCTION PTR24TO32(cmd:Ptr): ptr; EXTERNAL;

	FUNCTION NUBUS_READ(slot: integer; offset:  longint):  longint; EXTERNAL;   
	PROCEDURE NUBUS_WRITE(slot: integer; offset, value:  longint);
	FUNCTION NUBUS_READ_BYTE(slot: integer; offset:  longint):  integer; EXTERNAL;   
	PROCEDURE NUBUS_WRITE_BYTE(slot: integer; offset: longint; value: integer);
	
	PROCEDURE BLOCK_SWAP_16B(aPtr, bPtr : Ptr; length : Longint);    EXTERNAL;
	PROCEDURE BLOCK_SWAP_32B(aPtr, bPtr : Ptr; length : longint);    EXTERNAL;

	PROCEDURE send_command(cmd:Ptr; ch:integer); EXTERNAL;
	PROCEDURE send_command_and_wait(cmd:Ptr; channel:integer);  EXTERNAL;

	FUNCTION  get_command(channel, no_hang_p:integer):Ptr; EXTERNAL;
	
	FUNCTION  get_acb(size:integer):Ptr; EXTERNAL;

	FUNCTION opcode(cmd:Ptr): integer;  EXTERNAL;
	PROCEDURE set_opcode(cmd:Ptr; value:integer);  EXTERNAL;
	
	FUNCTION subopcode(cmd:Ptr): integer;  EXTERNAL;
	PROCEDURE set_subopcode(cmd:Ptr; value:integer);  EXTERNAL;

	FUNCTION servicer_complete(cmd:Ptr): Boolean;  EXTERNAL;
	PROCEDURE set_servicer_complete(cmd:Ptr; value:Boolean);  EXTERNAL;

	FUNCTION requestor_complete(cmd:Ptr): Boolean;  EXTERNAL;
	PROCEDURE set_requestor_complete(cmd:Ptr; value:Boolean);  EXTERNAL;

	FUNCTION input_complete(cmd:Ptr): Boolean; EXTERNAL;
	PROCEDURE set_input_complete(cmd:Ptr; value:Boolean); EXTERNAL;

	FUNCTION error_code(cmd:Ptr): integer;  EXTERNAL;
	PROCEDURE set_error_code(cmd:Ptr; value:integer);  EXTERNAL;

	FUNCTION parm_bytes(cmd:Ptr): longint;  EXTERNAL;
	PROCEDURE set_parm_bytes(cmd:Ptr; value:longint);  EXTERNAL;

	FUNCTION data_bytes(cmd:Ptr): longint;  EXTERNAL;
	PROCEDURE set_data_bytes(cmd:Ptr; value:longint);  EXTERNAL;

	FUNCTION parm_8b(cmd:Ptr; parm_number:longint): integer;  EXTERNAL;
	PROCEDURE set_parm_8b(cmd:Ptr; parm_number:longint; value:integer);  EXTERNAL;
	FUNCTION parm_8b_addr(cmd:Ptr; parm_number:longint): ptr;  EXTERNAL;
	PROCEDURE copy_parms_8b(cmd,arr:Ptr;
								 parm_number, number_of_parms_to_copy, direction:longint); EXTERNAL;

	FUNCTION parm_16b(cmd:Ptr; parm_number:longint): integer;  EXTERNAL;
	PROCEDURE set_parm_16b(cmd:Ptr; parm_number:longint; value:integer);  EXTERNAL;
	FUNCTION parm_16b_addr(cmd:Ptr; parm_number:longint): ptr;  EXTERNAL;
	PROCEDURE copy_parms_16b(cmd,arr:Ptr;
								 parm_number, number_of_parms_to_copy, direction:longint); EXTERNAL;
	

	FUNCTION parm_32b(cmd:Ptr; parm_number:longint): longint;  EXTERNAL;  {**ab**}
	PROCEDURE set_parm_32b(cmd:Ptr; parm_number:longint; value:longint);  EXTERNAL;  {**ab**}
	FUNCTION parm_32b_addr(cmd:Ptr; parm_number:longint): ptr;  EXTERNAL;
	PROCEDURE copy_parms_32b(cmd,arr:Ptr;
								 parm_number, number_of_parms_to_copy, direction:longint); EXTERNAL;


END.

